export type InvoiceStatus = 'pending' | 'paid' | 'failed';
export type Currency = 'NGN' | 'USD';

export interface Invoice {
  id: string;
  vendor_id: string;
  customer_id?: string | null;
  customer_name: string;
  customer_email: string;
  currency: Currency;
  subtotal: number;
  fee: number;
  total: number;
  status: InvoiceStatus;
  notes?: string;
  due_date?: string;
  pdf_url?: string;
  public_code: string;
  created_at: string;
}

export interface InvoiceItem {
  id: string;
  invoice_id: string;
  name: string;
  quantity: number;
  unit_price: number;
  total_price: number;
}

export interface Transaction {
  id: string;
  invoice_id: string;
  vendor_id: string;
  amount: number;
  currency: Currency;
  paid_at: string;
  payment_gateway: string;
  status: 'success' | 'failed';
}

export interface Payout {
  id: string;
  vendor_id: string;
  amount: number;
  status: 'pending' | 'completed' | 'failed';
  created_at: string;
  approved_at?: string;
}

export interface CreateInvoiceRequest {
  currency: Currency;
  customer_id?: string | null;
  customer_name: string;
  customer_email: string;
  items: Array<{ name: string; quantity: number; unit_price: number }>;
  notes?: string;
  due_date?: string;
} 